## Overview
- Understand how packet processing is influenced by policies on Cisco Secure Firewall Threat Defense devices.

## Engines
- **LINA Engine**: Handles traffic processing at Layer 3/Layer 4, including IP routing, ACL filtering, NAT, and VPN.
- **Snort Engine**: Conducts deeper traffic inspection, managing security intelligence, IPS, and URL filtering.

## Packet Processing Sequence
![[Pasted image 20250325221301.png]]
1. **Ingress Interface Processing**: Network Interface Card buffers and processes incoming packets.
2. **Connection Check**: Determines if the packet is part of an existing session to skip some checks.
3. **VPN Decryption**: Supports IKEv1/IKEv2 IPsec VPN and SSL for remote access VPN.
4. **Routing Check**: Identifies egress interface based on NAT configuration.
5. **Prefilter Policy Check**: Fastpaths traffic excluding it from Snort engine inspection.
6. **Access List Check**: Applies Layer 3/Layer 4 access control policy rules.
7. **Snort Engine Inspection**: For packets requiring deeper inspection as per ACP configuration.
8. **Verdict Handling**: Snort engine verdict updates flow in LINA engine; packet is dropped or forwarded.
9. **NAT Processing**: Performed before egress.
10. **Traffic Encryption**: Encrypts traffic matching crypto access-list.
11. **Next Hop Determination**: Uses routing table to find next hop IP address.
12. **Layer 2 Information**: Determines MAC address for packet transmission.

## Cisco Secure Firewall Threat Defense Policies

##### Prefilter Policies

- Implemented in the LINA engine to fastpath traffic, excluding it from Snort inspection.
- Uses outermost header for tunneled traffic assessment.

##### Snort Engine Policies

![[Pasted image 20250325221445.png]]

- **Security Intelligence**: Blocks or ignores traffic without further inspection.
- **DNS Policy**: Monitors DNS requests, prevents connections to malicious domains, and uses DNS Sinkhole for compromised PC identification.
- **Access Policy (ACP)**: Central component inspecting traffic up to Layer 7, integrating URL lists, IPS, and file policies.
- **File Policies**: Inspects specific file types and categories, providing malware protection.
- **Intrusion Policies**: Provides deep packet inspection, preprocessing traffic for IPS Snort rules.

##### SSL Policies

- Handles SSL/TLS traffic encryption/decryption, offering options for traffic not decryptable.
- Provides hardware performance advantage for SSL decryption on physical platforms.

##### Additional Policies

- **Network Discovery Policies**: Discover network applications, users, and hosts.
- **Correlation Policies**: Automates alerts or responses based on network behavior.
- **Identity Policies**: Assigns user identity for ACP, utilizing LDAP or Active Directory.

## Cisco Secure Firewall Threat Defense Policy Relationships
![[Pasted image 20250325221429.png]]
- ACP is central to policy configuration; other policies attach globally or per ACP rule.
- Each ACP rule can specify unique actions for matched traffic, with flexibility in default actions.

## Cisco Secure Firewall Threat Defense Policy Deployment

- Use Secure Firewall Management Center for configuration.
- Deployment action distributes configuration components like access control policies, intrusion rules, and VPN setups.
- Configuration can be deployed automatically through scheduled tasks.